## Polyline exercise

### Step 1

Implement a function

    addPolyline :: String -> String -> (Double,Double) -> [(Double,Double)] -> <Proc> ()

that is called as

    addPolyline diagramName name location polylineData

It creates a polyline `name` to the diagram `diagramName` at `location`.
The polyline should interpolate the points `polylineData`
(assumed in this step to contain at most 30 points).

You need the following functions:

::value[Apros/Legacy/aadd,Apros/Legacy/amodi]

And the following symbol and attributes

    Polyline
        FUNCTION_X_COORDINATE(i)
        FUNCTION_Y_COORDINATE(i)
        FUNCTION_OK(i)

Test that your function produces a functional model configuration.

### Step 2

Extend your function so that it supports also `polylineList` with more
than 30 points. For example

    addPolyline "Diagram" "PL" (100,100) [(x,sin x) | i <- [0..100], x = 0.1*fromInteger i]

might produce the following model configuration:

![](http://www.simantics.org/~niemisto/SCL20150513/Polyline.png)

You may implement the polyline using the following symbols and attributes

    Polyline
        FUNCTION_X_COORDINATE(i)
        FUNCTION_Y_COORDINATE(i)
        FUNCTION_OK(i)
        FUNCTION_INPUT_SIGN
        FUNCTION_OUTPUT_SIGN
    BranchAnalog
        AMUX_INPUT_SIGN
        AMUX_OUTPUT_SIGN(i)
    LV_CHECKER
        LVC_INPUT_SIGN
        LVC_LIMIT_VALUE
        LVC_OUTPUT_SIGN_1
    ANALOG_SWITCH
        SWITCH_CONTROL_S
        SWITCH_INP_SIGN_1
        SWITCH_INP_SIGN_2
        SWITCH_OUTP_SIGN


You need in addition to `aadd` and `amodi` the function

::value[Apros/Legacy/aconnect]

Test that your function produces a functional model configuration.